/* ***** BEGIN LICENSE BLOCK *****
 * Distributed under the BSD license:
 *
 * Copyright (c) 2012, Ajax.org B.V.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Ajax.org B.V. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL AJAX.ORG B.V. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ***** END LICENSE BLOCK ***** */

/* This file was autogenerated from cisco_ios.tmLanguage (uuid: ) */
/****************************************************************************************
 * IT MIGHT NOT BE PERFECT ...But it's a good start from an existing *.tmlanguage file. *
 * fileTypes                                                                            *
 ****************************************************************************************/

define(function(require, exports, module) {
"use strict";

var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;

var CiscoIOSHighlightRules = function() {
    // regexp must not have capturing parentheses. Use (?:) instead.
    // regexps are ordered -> the first match is used

    this.$rules = {
        start: [{
            include: "#comment"
        }, {
            include: "#control"
        }, {
            include: "#ip_address"
        }, {
            include: "#number"
        }, {
            include: "#variable"
        }, {
            include: "#operator"
        }, {
            include: "#url"
        }, {
            include: "#router"
        }, {
            include: "#interface_clause"
        }],
        "#comment": [{
            token: [
                "puncuation.definition.comment.ios",
                "comment.line.number-sign.ios"
            ],
            regex: /(!)(.*$)/
        }],
        "#control": [{
            token: "keyword.control.ios",
            regex: /\b(?:no|no sh|shut|shutdown|reload|reset|activate)\b/
        }],
        "#interface_clause": [{
            token: [
                "meta.interface.ios",
                "entity.name.type.interface.ios",
                "meta.interface.ios"
            ],
            regex: /^(\s*)(interface|int)(\s+)(?=[A-Za-z-]+[0-9\/. ]*)/,
            push: [{
                token: "meta.interface.ios",
                regex: /\s*$/,
                next: "pop"
            }, {
                include: "#interface_id"
            }, {
                token: "invalid.illegal.interface-id.ios",
                regex: /.*$/
            }, {
                defaultToken: "meta.interface.ios"
            }]
        }],
        "#interface_id": [{
            token: "support.constant.type.interface.ios",
            regex: /\b(?:(?:fast|gigabit|)ethernet|null|bvi|virtual-?[a-z]*|fa|gi|e|se|serial|lo|loopback|tun|tunnel)(?=\s?[0-9])/,
            caseInsensitive: true,
            push: [{
                token: "constant.numeric.interface-number.ios",
                regex: /[0-9][0-9\/. ]*\b/,
                next: "pop"
            }, {
                defaultToken: "meta.interface-id.ios"
            }]
        }],
        "#ip_address": [{
            token: "constant.numeric.ip-address.ios",
            regex: /\s(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\s/
        }, {
            token: "invalid.illegal.ip-address.ios",
            regex: /\s(?:25[6-9]|2[6-9][0-9]|[3-9]?[0-9][0-9]?)\.\b/
        }],
        "#number": [{
            token: "constant.numeric.integer.ios",
            regex: /\b(?:[1-9]+[0-9]*|0)\b/
        }],
        "#operator": [{
            token: "keyword.operator.comparison.ios",
            regex: /\b(?:eq|neq|gt|lt|range|ge|le)\b/,
            caseInsensitive: true
        }],
        "#router": [{
            token: [
                "meta.router.ios",
                "entity.name.type.router.ios",
                "meta.router.ios"
            ],
            regex: /^(\s*)(router)(\s+)(?=[A-Za-z-]+[0-9 ]*)/,
            push: [{
                token: "meta.router.ios",
                regex: /\s*$/,
                next: "pop"
            }, {
                include: "#router_id"
            }, {
                token: "invalid.illegal.router-id.ios",
                regex: /.*$/
            }, {
                defaultToken: "meta.router.ios"
            }]
        }],
        "#router_id": [{
            token: "support.constant.type.router.ios",
            regex: /\b(?:eigrp|rip|isis|odr|ospf|bgp|mobile)/,
            caseInsensitive: true,
            push: [{
                token: [],
                regex: /(?:\s+[0-9]+|[A-Z]+|)\b/,
                next: "pop"
            }, {
                defaultToken: "meta.router-id.ios"
            }]
        }],
        "#url": [{
            token: "string.unquoted.ios",
            regex: /\b(?:https?|t?ftps?|flash|disk[0-9]|scp|ssh|telnet):(?=[A-Za-z0-9_.\/-])/,
            push: [{
                token: "string.unquoted.ios",
                regex: /(?=\s+)/,
                next: "pop"
            }, {
                defaultToken: "string.unquoted.ios"
            }]
        }],
        "#variable": [{
            token: "variable.parameter.ios",
            regex: /\b[A-Z]+[A-Z0-9_ -]*\b/,
            comment: "User created objects"
        }]
    }
    
    this.normalizeRules();
};

CiscoIOSHighlightRules.metaData = {
    fileTypes: ["ios"],
    foldingStartMarker: "^\\s*.+$",
    foldingStopMarker: "^\\s*!.*$",
    name: "Cisco IOS",
    scopeName: "text.ios"
}


oop.inherits(CiscoIOSHighlightRules, TextHighlightRules);

exports.CiscoIOSHighlightRules = CiscoIOSHighlightRules;
});